<?php
/**
 * Plugin Name: Image Compression Plugin
 * Plugin URI: https://yourwebsite.com
 * Description: Automatically compress and optimize images using TinyPNG API with before/after comparisons and bulk compression.
 * Version: 1.0.0
 * Author: Your Name
 * License: GPL v2 or later
 * Text Domain: image-compression-plugin
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('ICP_PLUGIN_URL', plugin_dir_url(__FILE__));
define('ICP_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('ICP_VERSION', '1.0.0');

class ImageCompressionPlugin {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('init', array($this, 'init'));
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
    }
    
    public function init() {
        // Load required files
        $this->load_dependencies();
        
        // Initialize components
        $this->init_hooks();
    }
    
    private function load_dependencies() {
        require_once ICP_PLUGIN_PATH . 'includes/class-icp-database.php';
        require_once ICP_PLUGIN_PATH . 'includes/class-icp-backup.php';
        require_once ICP_PLUGIN_PATH . 'includes/class-icp-tinypng-api.php';
        require_once ICP_PLUGIN_PATH . 'includes/class-icp-admin.php';
        require_once ICP_PLUGIN_PATH . 'includes/class-icp-compressor.php';
        require_once ICP_PLUGIN_PATH . 'includes/class-icp-scheduler.php';
    }
    
    private function init_hooks() {
        // Initialize admin panel
        if (is_admin()) {
            new ICP_Admin();
        }
        
        // Initialize compressor
        new ICP_Compressor();
        
        // Initialize scheduler
        new ICP_Scheduler();
    }
    
    public function activate() {
        // Load database class for activation
        require_once ICP_PLUGIN_PATH . 'includes/class-icp-database.php';
        
        // Create database tables
        ICP_Database::create_tables();
        
        // Set default options
        if (!get_option('icp_settings')) {
            add_option('icp_settings', array(
                'api_key' => '',
                'auto_compress' => 1
            ));
        }
    }
    
    public function deactivate() {
        // Clean up scheduled events
        wp_clear_scheduled_hook('icp_scheduled_compression');
        
        // Clean up if needed
    }
}

// Initialize the plugin
ImageCompressionPlugin::get_instance(); 